'use strict'
/**
 * 电子签合同日志表
 */
module.exports = function (db, DataTypes) {
    return db.define('eordersignlog', {
            order_id: {type: DataTypes.STRING, field: 'order_id', allowNull: true, defaultValue:'',comment:'订单号' },
            product_id: {type: DataTypes.STRING, field: 'product_id', allowNull: true,defaultValue:'', comment:'产品id'},
            merchant_id: {type: DataTypes.STRING, field: 'merchant_id', allowNull: true, defaultValue:'',comment:'商户id' },
            spended_at: {type: DataTypes.DATE, field: 'spended_at', allowNull: true, defaultValue:null, comment:'生效时间' },
            platform_id: {type: DataTypes.STRING, field: 'platform_id', allowNull: true, defaultValue:'',comment:'平台ID' },
            platform_name: {type: DataTypes.STRING, field: 'platform_name', allowNull: true,defaultValue:'', comment:'平台名称' },
            spended_num: { type: DataTypes.INTEGER, field: 'spended_num', allowNull: false,defaultValue:0, comment:'消费数量'},
            actual_spend_name:{ type: DataTypes.STRING, field: 'actual_spend_name', allowNull: true, defaultValue:'',comment:'实际使用方'},
            engine_trade_id: {type: DataTypes.STRING, field: 'engine_trade_id', allowNull: true,defaultValue:'', comment:'引擎交易id'},
            engine_contract_id:{ type: DataTypes.STRING, field: 'engine_contract_id', allowNull: true, defaultValue:'',comment:'引擎合同id(签署ID)'},
            engine_contract_name:{ type: DataTypes.STRING, field: 'engine_contract_name', allowNull: true, defaultValue:'',comment:'引擎合同名称(签署任务名称)'},
            created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false},
            updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false},
            deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
            version: { type: DataTypes.BIGINT, field: 'version', defalut:0,allowNull: true }
        },
        {
            paranoid: true, //假的删除
            underscored: true,
            version: true,
            freezeTableName: true,
            tableName: 'e_order_sign_log',
        });
}

