'use strict'
/**
 * 身份认证日志表
 */
module.exports = function (db, DataTypes) {
    return db.define('eorderauthlog', {
            order_id: {type: DataTypes.STRING, field: 'order_id', allowNull: true, defaultValue:'',comment:'订单号' },
            merchant_id: {type: DataTypes.STRING, field: 'merchant_id', allowNull: true, defaultValue:'',comment:'商户id' },
            product_id: {type: DataTypes.STRING, field: 'product_id', allowNull: true,defaultValue:'', comment:'产品id'},
            spended_at: {type: DataTypes.DATE, field: 'spended_at', allowNull: true, defaultValue:null, comment:'生效时间' },
            platform_id: {type: DataTypes.STRING, field: 'platform_id', allowNull: true, defaultValue:'',comment:'平台ID' },
            platform_name: {type: DataTypes.STRING, field: 'platform_name', allowNull: true,defaultValue:'', comment:'平台名称' },
            spended_num: { type: DataTypes.INTEGER, field: 'spended_num', allowNull: false,defaultValue:0, comment:'消费数量'},
            user_name: {type: DataTypes.STRING, field: 'user_name', allowNull: true,defaultValue:'', comment:'使用方'},
            actual_spend_name:{ type: DataTypes.STRING, field: 'actual_spend_name', allowNull: true, defaultValue:'',comment:'实际使用方'},
            engine_trade_id:{ type: DataTypes.STRING, field: 'engine_trade_id', allowNull: true, defaultValue:'',comment:'引擎交易id'},
            pass: { type: DataTypes.INTEGER, field: 'pass', allowNull: true, defaultValue:0,comment:'是否通过'},
            created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false},
            updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false},
            deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
            version: { type: DataTypes.BIGINT, field: 'version', defalut:0,allowNull: true }
        },
        {
            paranoid: true, //假的删除
            underscored: true,
            version: true,
            freezeTableName: true,
            tableName: 'e_order_auth_log',
        });
}

