'use strict'
/**
 * 订单表
 */
module.exports = function (db, DataTypes) {
    return db.define('eorder', {
            merchant_id: {type: DataTypes.STRING, field: 'merchant_id', allowNull: true, defaultValue:'',comment:'商户id' },
            merchant_name: {type: DataTypes.STRING, field: 'merchant_name', allowNull: true, defaultValue:'',comment:'商户名称' },
            sign_name: {type: DataTypes.STRING, field: 'sign_name', allowNull: true,defaultValue:'', comment:'签署名称' },
            sign_id: { type: DataTypes.STRING, field: 'sign_id', allowNull: false,defaultValue:'', comment:'签署ID'},
            product_id: {type: DataTypes.STRING, field: 'product_id', allowNull: true,defaultValue:'', comment:'产品id'},
            product_type: {type: DataTypes.STRING, field: 'product_type', allowNull: true,defaultValue:'', comment:'产品类型'},
            product_unit_price:{ type: DataTypes.STRING, field: 'product_unit_price', allowNull: true, defaultValue:'',comment:'产品单价'},
            product_desc:{ type: DataTypes.STRING, field: 'product_desc', allowNull: true, defaultValue:'',comment:'产品描述'},
            price: { type: DataTypes.BIGINT, field: 'price', allowNull: true, defaultValue:0,comment:'订单价格'},
            product_specifications: { type: DataTypes.INTEGER, field: 'product_specifications', allowNull: true, defaultValue:0,comment:'产品规格数量'},
            contract_url: {type: DataTypes.STRING, field: 'contract_url', allowNull: true,  defaultValue:'',comment:'合同Url' },
            live_start: {type: DataTypes.DATE, field: 'live_start', allowNull: true, defaultValue:null, comment:'生效时间' },
            live_end: {type: DataTypes.DATE, field: 'live_end', allowNull: true, defaultValue:null, comment:'结束时间' },
            audit_status: {type: DataTypes.STRING, field: 'audit_status', allowNull: true, defaultValue:'10', comment:'审核状态10 待审核 20 审核成功 30 审核失败' },
            audit_date: {type: DataTypes.STRING, field: 'audit_date', allowNull: true, defaultValue:null, comment:'审核时间' },
            audit_remark: {type: DataTypes.STRING, field: 'audit_remark', allowNull: true, defaultValue:'', comment:'审核备注' },
            audit_user_id: {type: DataTypes.STRING, field: 'audit_user_id', allowNull: true, defaultValue:'', comment:'审核人' },
            live_status: {type: DataTypes.STRING, field: 'live_status', allowNull: true, defaultValue:'10', comment:'生效状态10 待生效 20 已生效 30 已终止' },
            pay_status: {type: DataTypes.STRING, field: 'pay_status', allowNull: true, defaultValue:'10', comment:'支付状态10 待支付 20 已支付 30 支付失败' },
            pay_date: {type: DataTypes.DATE, field: 'pay_date', allowNull: true, defaultValue:null, comment:'支付时间' },
            engine_account_id: {type: DataTypes.STRING, field: 'engine_account_id', allowNull: true, defaultValue:'', comment:'计费引擎账户id' },
            created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false},
            updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false},
            deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
            version: { type: DataTypes.BIGINT, field: 'version', defalut:0,allowNull: true }
        },
        {
            paranoid: true, //假的删除
            underscored: true,
            version: true,
            freezeTableName: true,
            tableName: 'e_order',
        });
}

