const system=require("../../../system");
const Dao=require("../../dao.base");
class EordersignlogDao extends Dao{
    constructor(){
        super(Dao.getModelName(EordersignlogDao));

    }

    /**
     * fn:分页查询计数
     * @param params
     * @returns {Promise<void>}
     */
    async countEorderSignLog(params){
        let sql = [];
        sql.push('SELECT COUNT(1) AS eordersignlogCount FROM e_order_sign_log WHERE 1 = 1 ');
        this.setEorderSignLogParams(sql,params);
        let list = await this.customQuery(sql.join(" "), params);
        if(!list || list.length==0){
            return {count:0};
        }
        return list[0];
    }

    async setEorderSignLogParams(sql,params){
        if(params.id){
            sql.push('and id=:id');
        }
        if(params.order_id){
            sql.push('and order_id=:order_id');
        }
        if (params.spendedBegin) {
            sql.push("AND spended_at >= :spendedBegin");
        }
        if (params.spendedEnd) {
            sql.push("AND spended_at <= :spendedEnd");
        }
    }

    /**
     * fn:分页查询
     * @param params
     * @returns {Promise<void>}
     */
    async pageEorderSignLog(params){
        let sql = [];
        sql.push('SELECT *  FROM e_order_sign_log WHERE 1 = 1 ');
        this.setEorderSignLogParams(sql,params);
        sql.push("ORDER BY spended_at DESC");
        sql.push("LIMIT :startRow, :pageSize");
        let list = await this.customQuery(sql.join(" "), params);
        return list ||[];
    }


    /**
     * fn:创建对象
     * ps:为了防止 签约日志和身份日志 id 出现重复
     * @param u
     * @returns {Promise<*>}
     */
    async preCreate(u) {
        if (!u.id && !u.autoIncrement) {
            u.id = await this.redisClient.genrateId(`EorderLog`);
        }
        return u;
    }
    async create(u, t) {
        var u2 = await this.preCreate(u);
        if (t) {
            return this.model.create(u2, {
                transaction: t
            }).then(u => {
                return u;
            });
        } else {
            return this.model.create(u2, {
                transaction: t
            }).then(u => {
                return u;
            });
        }
    }

    /**
     * 合同列表（分页）计数
     * @param params
     * @returns {Promise<*|*[]>}
     */
    async countEordersignlogContract(params){
        let sql = [];
        sql.push(`SELECT count(1) as count`);
        sql.push(`FROM e_order_sign_log t1 inner join e_order t2 on t2.id =t1.order_id WHERE 1 = 1 `)
        this.setpageEorderContractParams(sql,params);
        let list = await this.customQuery(sql.join(" "), params);
        if(!list || list.length==0){
            return {count:0};
        }
        return list[0];
    }

    setpageEorderContractParams(sql,params){
        if(params.engine_contract_id){
            sql.push('and t1.engine_contract_id=:engine_contract_id');
        }
        if(params.order_id){
            sql.push('and t1.order_id=:order_id');
        }
    }

    async PageeordersignlogContract(params){
        let sql = [];
        sql.push(`SELECT t1.engine_contract_id,t1.engine_contract_name,t1.created_at,t2.live_start,t2.live_end,t2.merchant_name,t1.order_id  `);
        sql.push(`FROM e_order_sign_log t1 inner join e_order t2 on t2.id =t1.order_id WHERE 1 = 1 `)
        this.setpageEorderContractParams(sql,params);
        sql.push("ORDER BY t1.created_at DESC");
        sql.push("LIMIT :startRow, :pageSize");
        let list = await this.customQuery(sql.join(" "), params);
        return list ||[];
    }

}
module.exports=EordersignlogDao;
