const system=require("../../../system");
const Dao=require("../../dao.base");
class EorderproductDao extends Dao{
    constructor(){
        super(Dao.getModelName(EorderproductDao));
    }

    /**
     * fn:根据订单ID查询产品信息
     * @param params
     * @returns {Promise<void>}
     */
    async findAllByOrderId(params){
        let sql = [];
        sql.push('SELECT * FROM e_order_product WHERE 1 = 1 ');
        this.setEorderParams(sql,params);
        sql.push(`order by created_at desc`);
        let list = await this.customQuery(sql.join(" "), params);
        return list || [];
    }

    setEorderParams(sql,params){
        if(params.order_id){
            sql.push('and order_id = :order_id');
        }
        if(params.order_ids && params.order_ids.length!=0){
            sql.push('and order_id in (:order_ids)');
        }
    }

    /**
     * fn:物理删除订单-产品关系表
     * @param params
     * @returns {Promise<*>}
     */
    async delete(params){
        if(!params.order_id){
            return ;
        }
        let sql = [];
        sql.push('DELETE  FROM e_order_product WHERE 1 = 1 ');
        this.setEorderParams(sql,params);
        let res=  await this.customUpdate(sql.join(" "), params);
        return res;
    }

    /**
     * fn:根据订单ID查询产品信息（创建时间降序排列）
     * @param params
     * @returns {Promise<*|*[]>}
     */
    async findAllByOrderIdCreatedAsc(params){
        let sql = [];
        sql.push(`SELECT t1.order_id,t1.product_id FROM e_order_product t1 INNER JOIN e_order t2 ON t1.order_id = t2.id where 1=1 and  t2.live_status ='20'`);
        sql.push(`and t1.product_id =:product_id and t2.merchant_id=:merchant_id`);
        sql.push(`ORDER BY t2.created_at ASC`);
        let list = await this.customQuery(sql.join(" "), params);
        return list;
    }
}
module.exports=EorderproductDao;
