const system=require("../../../system");
const Dao=require("../../dao.base");
class EorderauthlogDao extends Dao{
    constructor(){
        super(Dao.getModelName(EorderauthlogDao));
    }

    /**
     * fn:分页查询计数
     * @param params
     * @returns {Promise<void>}
     */
    async countEorderAuthLog(params){
        let sql = [];
        sql.push('SELECT COUNT(1) AS eorderauthlogCount FROM e_order_auth_log WHERE 1 = 1 ');
        this.setEorderAuthLogParams(sql,params);
        let list = await this.customQuery(sql.join(" "), params);
        if(!list || list.length==0){
            return {count:0};
        }
        return list[0];
    }

    async setEorderAuthLogParams(sql,params){
        if(params.id){
            sql.push('and id=:id');
        }
        if(params.merchant_id){
            sql.push('and merchant_id=:merchant_id');
        }
        if(params.order_id){
            sql.push('and order_id=:order_id');
        }
        if (params.spendedBegin) {
            sql.push("AND spended_at >= :spendedBegin");
        }
        if (params.spendedEnd) {
            sql.push("AND spended_at <= :spendedEnd");
        }
    }

    /**
     * fn:分页查询
     * @param params
     * @returns {Promise<void>}
     */
    async pageEorderAuthLog(params){
        let sql = [];
        sql.push('SELECT *  FROM e_order_auth_log WHERE 1 = 1 ');
        this.setEorderAuthLogParams(sql,params);
        sql.push("ORDER BY spended_at DESC");
        sql.push("LIMIT :startRow, :pageSize");
        let list = await this.customQuery(sql.join(" "), params);
        return list ||[];
    }


    /**
     * fn:创建对象
     * ps:为了防止 签约日志和身份日志 id 出现重复
     * @param u
     * @returns {Promise<*>}
     */
    async preCreate(u) {
        if (!u.id && !u.autoIncrement) {
            u.id = await this.redisClient.genrateId(`EorderLog`);
        }
        return u;
    }
    async create(u, t) {
        var u2 = await this.preCreate(u);
        if (t) {
            return this.model.create(u2, {
                transaction: t
            }).then(u => {
                return u;
            });
        } else {
            return this.model.create(u2, {
                transaction: t
            }).then(u => {
                return u;
            });
        }
    }


}
module.exports=EorderauthlogDao;
