const system=require("../../../system");
const Dao=require("../../dao.base");
class EorderDao extends Dao{
    constructor(){
        super(Dao.getModelName(EorderDao));
    }

    /**
     * fn:记录总数
     * @param params
     * @returns {Promise<void>}
     */
    async countEorder(params){
        let sql = [];
        sql.push('SELECT COUNT(1) AS eorderCount FROM e_order WHERE 1 = 1 ');
        this.setEorderParams(sql,params);
        let list = await this.customQuery(sql.join(" "), params);
        if(!list || list.length==0){
            return {count:0};
        }
        return list[0];
    }

    setEorderParams(sql,params){
        if(params.id){
            sql.push('and id=:id');
        }
        if(params.merchant_id){
            sql.push('and merchant_id=:merchant_id');
        }
        if(params.merchant_name){
            sql.push('and merchant_name=:merchant_name');
        }
        if(params.sign_id){
            sql.push('and sign_id=:sign_id');
        }
        if(params.product_id){
            sql.push('and product_id=:product_id');
        }
        if(params.product_type){
            sql.push('and product_type=:product_type');
        }
        if(params.audit_status){
            params.pay_status="20";
            sql.push(`and audit_status=:audit_status and pay_status=:pay_status`);
        }
        if(params.live_status){
            params.pay_status="20";
            params.audit_status="20";
            sql.push('and live_status=:live_status and pay_status=:pay_status  and audit_status=:audit_status');
        }
        if(params.pay_status){

            sql.push('and pay_status=:pay_status');
        }
        if(params.audit_user_id){
            sql.push('and audit_user_id=:audit_user_id');
        }
        if (params.createdBegin) {
            sql.push("AND created_at >= :createdBegin");
        }
        if (params.createdEnd) {
            sql.push("AND created_at <= :createdEnd");
        }
        if (params.payBegin) {
            sql.push("AND pay_date >= :payBegin");
        }
        if (params.payEnd) {
            sql.push("AND pay_date <= :payEnd");
        }
        if (params.auditBegin) {
            sql.push("AND audit_date >= :auditBegin");
        }
        if (params.auditEnd) {
            sql.push("AND audit_date <= :auditEnd");
        }
    }

    /**
     * fn:订单分页查询
     * @param params
     * @returns {Promise<void>}
     */
    async pageEorder(params){
        let sql = [];
        sql.push('SELECT *  FROM e_order  WHERE 1 = 1 ');
        this.setEorderParams(sql,params);
        sql.push("ORDER BY created_at DESC");
        sql.push("LIMIT :startRow, :pageSize");
        let list = await this.customQuery(sql.join(" "), params);

        return list ||[];
    }

}
module.exports=EorderDao;
