var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.eorderSve = system.getObject("service.eorder.eorderSve");
        this.eorderproductSve = system.getObject("service.eorder.eorderproductSve");
        this.eorderauthlogSve = system.getObject("service.eorder.eorderauthlogSve");
        this.eordersignlogSve = system.getObject("service.eorder.eordersignlogSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        var result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);    
        } catch (error) {
            console.log(error);
        }
        
        return result;
    }

    async handleRequest(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            case "saveEorder":// 保存订单
                opResult = await this.eorderSve.saveEorder(action_body);
                break;
            case "auditEorder":// 审核订单
                opResult = await this.eorderSve.auditEorder(action_body);
                break;
            case "updEorderStatus":// 更改订单状态
                opResult = await this.eorderSve.updEorderStatus(action_body);
                break;
            case "updOrderSimple":// 更新订单（单表更新）
                opResult = await this.eorderSve.updOrderSimple(action_body);
                break;
            case "getEorderById":// 查看订单
                opResult = await this.eorderSve.getEorderById(action_body);
                break;
            case "pageEorder":// 查看订单列表(分页)
                opResult = await this.eorderSve.pageEorder(action_body);
                break;
            case "listEorderProduct":// 查看订单列表
                opResult = await this.eorderproductSve.listEorderProduct(action_body);
                break;
            case "listEorderProductByMerchantId":// 查看当前商户下所有的订单相关的产品（没有分页）
                opResult = await this.eorderproductSve.listEorderProductByMerchantId(action_body);
                break;
            case "saveEorderAuthLog":// 保存身份认证日志
                opResult = await this.eorderauthlogSve.saveEorderAuthLog(action_body);
                break;
            case "pageEorderAuthLog":// 身份认证日志列表
                opResult = await this.eorderauthlogSve.pageEorderAuthLog(action_body);
                break;
            case "saveEorderSignLog":// 保存签约日志
                opResult = await this.eordersignlogSve.saveEorderSignLog(action_body);
                break;
            case "pageEorderSignLog":// 签约日志列表
                opResult = await this.eordersignlogSve.pageEorderSignLog(action_body);
                break;
            case "pageEorderContract":// 合同列表（分页）
                opResult = await this.eordersignlogSve.pageEorderContract(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre><pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;