'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateWithCustomRules = validateWithCustomRules;

var _graphql = require('graphql');

/**
 * Validate a GraphQL Document optionally with custom validation rules.
 */
function validateWithCustomRules(schema, ast, customRules, isRelayCompatMode) {
  // Because every fragment is considered for determing model subsets that may
  // be used anywhere in the codebase they're all technically "used" by clients
  // of graphql-data. So we remove this rule from the validators.
  var _require = require('graphql/validation/rules/NoUnusedFragments'),
      NoUnusedFragments = _require.NoUnusedFragments;

  var _require2 = require('graphql/validation/rules/ExecutableDefinitions'),
      ExecutableDefinitions = _require2.ExecutableDefinitions;

  var rulesToSkip = [NoUnusedFragments, ExecutableDefinitions];
  if (isRelayCompatMode) {
    var _require3 = require('graphql/validation/rules/KnownFragmentNames'),
        KnownFragmentNames = _require3.KnownFragmentNames;

    rulesToSkip.push(KnownFragmentNames);
  }
  var rules = _graphql.specifiedRules.filter(function (rule) {
    return !rulesToSkip.some(function (r) {
      return r === rule;
    });
  });

  var typeInfo = new _graphql.TypeInfo(schema);
  if (customRules) {
    Array.prototype.push.apply(rules, customRules);
  }

  var errors = (0, _graphql.validate)(schema, ast, rules, typeInfo);

  if (errors.length > 0) {
    return errors.filter(function (error) {
      if (error.message.indexOf('Unknown directive') === -1) {
        return true;
      }
      return !(error.nodes && error.nodes[0] && error.nodes[0].name && error.nodes[0].name.value === 'arguments' || error.nodes && error.nodes[0] && error.nodes[0].name && error.nodes[0].name.value && error.nodes[0].name.value === 'argumentDefinitions');
    });
  }

  return [];
} /**
   *  Copyright (c) Facebook, Inc.
   *  All rights reserved.
   *
   *  This source code is licensed under the license found in the
   *  LICENSE file in the root directory of this source tree.
   *
   *  
   */