'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphQLLanguageService = undefined;

var _graphql = require('graphql');

var _getAutocompleteSuggestions2 = require('./getAutocompleteSuggestions');

var _getHoverInformation2 = require('./getHoverInformation');

var _getDiagnostics = require('./getDiagnostics');

var _getDefinition = require('./getDefinition');

var _graphqlLanguageServiceUtils = require('@apollographql/graphql-language-service-utils');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
                                                                                                                                                           *  Copyright (c) Facebook, Inc.
                                                                                                                                                           *  All rights reserved.
                                                                                                                                                           *
                                                                                                                                                           *  This source code is licensed under the license found in the
                                                                                                                                                           *  LICENSE file in the root directory of this source tree.
                                                                                                                                                           *
                                                                                                                                                           *  
                                                                                                                                                           */

var FRAGMENT_DEFINITION = _graphql.Kind.FRAGMENT_DEFINITION,
    OBJECT_TYPE_DEFINITION = _graphql.Kind.OBJECT_TYPE_DEFINITION,
    INTERFACE_TYPE_DEFINITION = _graphql.Kind.INTERFACE_TYPE_DEFINITION,
    ENUM_TYPE_DEFINITION = _graphql.Kind.ENUM_TYPE_DEFINITION,
    UNION_TYPE_DEFINITION = _graphql.Kind.UNION_TYPE_DEFINITION,
    SCALAR_TYPE_DEFINITION = _graphql.Kind.SCALAR_TYPE_DEFINITION,
    INPUT_OBJECT_TYPE_DEFINITION = _graphql.Kind.INPUT_OBJECT_TYPE_DEFINITION,
    SCALAR_TYPE_EXTENSION = _graphql.Kind.SCALAR_TYPE_EXTENSION,
    OBJECT_TYPE_EXTENSION = _graphql.Kind.OBJECT_TYPE_EXTENSION,
    INTERFACE_TYPE_EXTENSION = _graphql.Kind.INTERFACE_TYPE_EXTENSION,
    UNION_TYPE_EXTENSION = _graphql.Kind.UNION_TYPE_EXTENSION,
    ENUM_TYPE_EXTENSION = _graphql.Kind.ENUM_TYPE_EXTENSION,
    INPUT_OBJECT_TYPE_EXTENSION = _graphql.Kind.INPUT_OBJECT_TYPE_EXTENSION,
    DIRECTIVE_DEFINITION = _graphql.Kind.DIRECTIVE_DEFINITION,
    FRAGMENT_SPREAD = _graphql.Kind.FRAGMENT_SPREAD,
    OPERATION_DEFINITION = _graphql.Kind.OPERATION_DEFINITION,
    NAMED_TYPE = _graphql.Kind.NAMED_TYPE;

var GraphQLLanguageService = exports.GraphQLLanguageService = function () {
  function GraphQLLanguageService(cache) {
    _classCallCheck(this, GraphQLLanguageService);

    this._graphQLCache = cache;
    this._graphQLConfig = cache.getGraphQLConfig();
  }

  GraphQLLanguageService.prototype.getDiagnostics = function getDiagnostics(query, uri, isRelayCompatMode) {
    var queryHasExtensions, projectConfig, schemaPath, queryAST, range, source, fragmentDefinitions, fragmentDependencies, dependenciesSource, validationAst, customRules, customRulesModulePath, rulesPath, schema;
    return regeneratorRuntime.async(function getDiagnostics$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            // Perform syntax diagnostics first, as this doesn't require
            // schema/fragment definitions, even the project configuration.
            queryHasExtensions = false;
            projectConfig = this._graphQLConfig.getConfigForFile(uri);
            schemaPath = projectConfig.schemaPath;
            _context.prev = 3;
            queryAST = (0, _graphql.parse)(query);

            if (!schemaPath || uri !== schemaPath) {
              queryHasExtensions = queryAST.definitions.some(function (definition) {
                switch (definition.kind) {
                  case OBJECT_TYPE_DEFINITION:
                  case INTERFACE_TYPE_DEFINITION:
                  case ENUM_TYPE_DEFINITION:
                  case UNION_TYPE_DEFINITION:
                  case SCALAR_TYPE_DEFINITION:
                  case INPUT_OBJECT_TYPE_DEFINITION:
                  case SCALAR_TYPE_EXTENSION:
                  case OBJECT_TYPE_EXTENSION:
                  case INTERFACE_TYPE_EXTENSION:
                  case UNION_TYPE_EXTENSION:
                  case ENUM_TYPE_EXTENSION:
                  case INPUT_OBJECT_TYPE_EXTENSION:
                  case DIRECTIVE_DEFINITION:
                    return true;
                }
                return false;
              });
            }
            _context.next = 12;
            break;

          case 8:
            _context.prev = 8;
            _context.t0 = _context['catch'](3);
            range = (0, _getDiagnostics.getRange)(_context.t0.locations[0], query);
            return _context.abrupt('return', [{
              severity: _getDiagnostics.SEVERITY.ERROR,
              message: _context.t0.message,
              source: 'GraphQL: Syntax',
              range: range
            }]);

          case 12:

            // If there's a matching config, proceed to prepare to run validation
            source = query;
            _context.next = 15;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDefinitions(projectConfig));

          case 15:
            fragmentDefinitions = _context.sent;
            _context.next = 18;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDependencies(query, fragmentDefinitions));

          case 18:
            fragmentDependencies = _context.sent;
            dependenciesSource = fragmentDependencies.reduce(function (prev, cur) {
              return prev + ' ' + (0, _graphql.print)(cur.definition);
            }, '');


            source = source + ' ' + dependenciesSource;

            validationAst = null;
            _context.prev = 22;

            validationAst = (0, _graphql.parse)(source);
            _context.next = 29;
            break;

          case 26:
            _context.prev = 26;
            _context.t1 = _context['catch'](22);
            return _context.abrupt('return', []);

          case 29:

            // Check if there are custom validation rules to be used
            customRules = void 0;
            customRulesModulePath = projectConfig.extensions.customValidationRules;

            if (customRulesModulePath) {
              /* eslint-disable no-implicit-coercion */
              rulesPath = require.resolve('' + customRulesModulePath);

              if (rulesPath) {
                customRules = require('' + rulesPath)(this._graphQLConfig);
              }
              /* eslint-enable no-implicit-coercion */
            }

            _context.next = 34;
            return regeneratorRuntime.awrap(this._graphQLCache.getSchema(projectConfig.projectName, queryHasExtensions).catch(function () {
              return null;
            }));

          case 34:
            schema = _context.sent;

            if (schema) {
              _context.next = 37;
              break;
            }

            return _context.abrupt('return', []);

          case 37:
            return _context.abrupt('return', (0, _getDiagnostics.validateQuery)(validationAst, schema, customRules, isRelayCompatMode));

          case 38:
          case 'end':
            return _context.stop();
        }
      }
    }, null, this, [[3, 8], [22, 26]]);
  };

  GraphQLLanguageService.prototype.getAutocompleteSuggestions = function getAutocompleteSuggestions(query, position, filePath) {
    var projectConfig, schema;
    return regeneratorRuntime.async(function getAutocompleteSuggestions$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            projectConfig = this._graphQLConfig.getConfigForFile(filePath);
            _context2.next = 3;
            return regeneratorRuntime.awrap(this._graphQLCache.getSchema(projectConfig.projectName).catch(function () {
              return null;
            }));

          case 3:
            schema = _context2.sent;

            if (!schema) {
              _context2.next = 6;
              break;
            }

            return _context2.abrupt('return', (0, _getAutocompleteSuggestions2.getAutocompleteSuggestions)(schema, query, position));

          case 6:
            return _context2.abrupt('return', []);

          case 7:
          case 'end':
            return _context2.stop();
        }
      }
    }, null, this);
  };

  GraphQLLanguageService.prototype.getHoverInformation = function getHoverInformation(query, position, filePath) {
    var projectConfig, schema;
    return regeneratorRuntime.async(function getHoverInformation$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            projectConfig = this._graphQLConfig.getConfigForFile(filePath);
            _context3.next = 3;
            return regeneratorRuntime.awrap(this._graphQLCache.getSchema(projectConfig.projectName).catch(function () {
              return null;
            }));

          case 3:
            schema = _context3.sent;

            if (!schema) {
              _context3.next = 6;
              break;
            }

            return _context3.abrupt('return', (0, _getHoverInformation2.getHoverInformation)(schema, query, position));

          case 6:
            return _context3.abrupt('return', '');

          case 7:
          case 'end':
            return _context3.stop();
        }
      }
    }, null, this);
  };

  GraphQLLanguageService.prototype.getDefinition = function getDefinition(query, position, filePath) {
    var projectConfig, ast, node;
    return regeneratorRuntime.async(function getDefinition$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            projectConfig = this._graphQLConfig.getConfigForFile(filePath);
            ast = void 0;
            _context4.prev = 2;

            ast = (0, _graphql.parse)(query);
            _context4.next = 9;
            break;

          case 6:
            _context4.prev = 6;
            _context4.t0 = _context4['catch'](2);
            return _context4.abrupt('return', null);

          case 9:
            node = (0, _graphqlLanguageServiceUtils.getASTNodeAtPosition)(query, ast, position);

            if (!node) {
              _context4.next = 17;
              break;
            }

            _context4.t1 = node.kind;
            _context4.next = _context4.t1 === FRAGMENT_SPREAD ? 14 : _context4.t1 === FRAGMENT_DEFINITION ? 15 : _context4.t1 === OPERATION_DEFINITION ? 15 : _context4.t1 === NAMED_TYPE ? 16 : 17;
            break;

          case 14:
            return _context4.abrupt('return', this._getDefinitionForFragmentSpread(query, ast, node, filePath, projectConfig));

          case 15:
            return _context4.abrupt('return', (0, _getDefinition.getDefinitionQueryResultForDefinitionNode)(filePath, query, node));

          case 16:
            return _context4.abrupt('return', this._getDefinitionForNamedType(query, ast, node, filePath, projectConfig));

          case 17:
            return _context4.abrupt('return', null);

          case 18:
          case 'end':
            return _context4.stop();
        }
      }
    }, null, this, [[2, 6]]);
  };

  GraphQLLanguageService.prototype._getDefinitionForNamedType = function _getDefinitionForNamedType(query, ast, node, filePath, projectConfig) {
    var objectTypeDefinitions, dependencies, localObjectTypeDefinitions, typeCastedDefs, localOperationDefinationInfos, result;
    return regeneratorRuntime.async(function _getDefinitionForNamedType$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return regeneratorRuntime.awrap(this._graphQLCache.getObjectTypeDefinitions(projectConfig));

          case 2:
            objectTypeDefinitions = _context5.sent;
            _context5.next = 5;
            return regeneratorRuntime.awrap(this._graphQLCache.getObjectTypeDependenciesForAST(ast, objectTypeDefinitions));

          case 5:
            dependencies = _context5.sent;
            localObjectTypeDefinitions = ast.definitions.filter(function (definition) {
              return definition.kind === OBJECT_TYPE_DEFINITION || definition.kind === INPUT_OBJECT_TYPE_DEFINITION || definition.kind === ENUM_TYPE_DEFINITION;
            });
            typeCastedDefs = localObjectTypeDefinitions;
            localOperationDefinationInfos = typeCastedDefs.map(function (definition) {
              return {
                filePath: filePath,
                content: query,
                definition: definition
              };
            });
            _context5.next = 11;
            return regeneratorRuntime.awrap((0, _getDefinition.getDefinitionQueryResultForNamedType)(query, node, dependencies.concat(localOperationDefinationInfos)));

          case 11:
            result = _context5.sent;
            return _context5.abrupt('return', result);

          case 13:
          case 'end':
            return _context5.stop();
        }
      }
    }, null, this);
  };

  GraphQLLanguageService.prototype._getDefinitionForFragmentSpread = function _getDefinitionForFragmentSpread(query, ast, node, filePath, projectConfig) {
    var fragmentDefinitions, dependencies, localFragDefinitions, typeCastedDefs, localFragInfos, result;
    return regeneratorRuntime.async(function _getDefinitionForFragmentSpread$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDefinitions(projectConfig));

          case 2:
            fragmentDefinitions = _context6.sent;
            _context6.next = 5;
            return regeneratorRuntime.awrap(this._graphQLCache.getFragmentDependenciesForAST(ast, fragmentDefinitions));

          case 5:
            dependencies = _context6.sent;
            localFragDefinitions = ast.definitions.filter(function (definition) {
              return definition.kind === FRAGMENT_DEFINITION;
            });
            typeCastedDefs = localFragDefinitions;
            localFragInfos = typeCastedDefs.map(function (definition) {
              return {
                filePath: filePath,
                content: query,
                definition: definition
              };
            });
            _context6.next = 11;
            return regeneratorRuntime.awrap((0, _getDefinition.getDefinitionQueryResultForFragmentSpread)(query, node, dependencies.concat(localFragInfos)));

          case 11:
            result = _context6.sent;
            return _context6.abrupt('return', result);

          case 13:
          case 'end':
            return _context6.stop();
        }
      }
    }, null, this);
  };

  return GraphQLLanguageService;
}();