"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.requiresFieldsMissingExternal = ({ schema, }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        for (const [fieldName, field] of Object.entries(namedType.getFields())) {
            const serviceName = field.federation && field.federation.serviceName;
            if (!serviceName)
                continue;
            if (field.federation && field.federation.requires) {
                const externalFieldsOnTypeForService = namedType.federation &&
                    namedType.federation.externals &&
                    namedType.federation.externals[serviceName];
                const selections = field.federation.requires;
                for (const selection of selections) {
                    const foundMatchingExternal = externalFieldsOnTypeForService
                        ? externalFieldsOnTypeForService.some(ext => ext.field.name.value === selection.name.value)
                        : undefined;
                    if (!foundMatchingExternal) {
                        errors.push(utils_1.errorWithCode('REQUIRES_FIELDS_MISSING_EXTERNAL', utils_1.logServiceAndType(serviceName, typeName, fieldName) +
                            `requires the field \`${selection.name.value}\` to be marked as @external.`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=requiresFieldsMissingExternal.js.map