"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const preNormalizationRules = __importStar(require("./preNormalization"));
const preCompositionRules = __importStar(require("./preComposition"));
const postCompositionRules = __importStar(require("./postComposition"));
const preNormalizationValidators = Object.values(preNormalizationRules);
function validateServicesBeforeNormalization(services) {
    const errors = [];
    for (const serviceDefinition of services) {
        for (const validator of preNormalizationValidators) {
            errors.push(...validator(serviceDefinition));
        }
    }
    return errors;
}
exports.validateServicesBeforeNormalization = validateServicesBeforeNormalization;
const preCompositionValidators = Object.values(preCompositionRules);
exports.validateServicesBeforeComposition = (services) => {
    const warningsOrErrors = [];
    for (const serviceDefinition of services) {
        for (const validator of preCompositionValidators) {
            warningsOrErrors.push(...validator(serviceDefinition));
        }
    }
    return warningsOrErrors;
};
const postCompositionValidators = Object.values(postCompositionRules);
exports.validateComposedSchema = ({ schema, serviceList, }) => {
    const warningsOrErrors = [];
    warningsOrErrors.push(...graphql_1.validateSchema(schema));
    for (const validator of postCompositionValidators) {
        warningsOrErrors.push(...validator({ schema, serviceList }));
    }
    return warningsOrErrors;
};
//# sourceMappingURL=index.js.map