import { GraphQLRequestListener } from "apollo-server-plugin-base";
declare type AnyFunction = (...args: any[]) => any;
declare type Args<F> = F extends (...args: infer A) => any ? A : never;
declare type AsFunction<F> = F extends AnyFunction ? F : never;
declare type UnwrapPromise<T> = T extends Promise<infer U> ? U : T;
declare type DidEndHook<TArgs extends any[]> = (...args: TArgs) => void;
export declare class Dispatcher<T extends GraphQLRequestListener> {
    protected targets: T[];
    constructor(targets: T[]);
    invokeHookAsync<TMethodName extends keyof T>(methodName: TMethodName, ...args: Args<T[TMethodName]>): Promise<UnwrapPromise<ReturnType<AsFunction<T[TMethodName]>>>[]>;
    invokeHooksUntilNonNull<TMethodName extends keyof T>(methodName: TMethodName, ...args: Args<T[TMethodName]>): Promise<UnwrapPromise<ReturnType<AsFunction<T[TMethodName]>>> | null>;
    invokeDidStartHook<TMethodName extends keyof T, TEndHookArgs extends Args<ReturnType<AsFunction<T[TMethodName]>>>>(methodName: TMethodName, ...args: Args<T[TMethodName]>): DidEndHook<TEndHookArgs>;
}
export {};
//# sourceMappingURL=dispatcher.d.ts.map