'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.offsetToPosition = offsetToPosition;
exports.locToRange = locToRange;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 *  Copyright (c) Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the license found in the
 *  LICENSE file in the root directory of this source tree.
 *
 *  
 */

var Range = exports.Range = function () {
  function Range(start, end) {
    var _this = this;

    _classCallCheck(this, Range);

    this.containsPosition = function (position) {
      if (_this.start.line === position.line) {
        return _this.start.character <= position.character;
      } else if (_this.end.line === position.line) {
        return _this.end.character >= position.character;
      } else {
        return _this.start.line <= position.line && _this.end.line >= position.line;
      }
    };

    this.start = start;
    this.end = end;
  }

  Range.prototype.setStart = function setStart(line, character) {
    this.start = new Position(line, character);
  };

  Range.prototype.setEnd = function setEnd(line, character) {
    this.end = new Position(line, character);
  };

  return Range;
}();

var Position = exports.Position = function () {
  function Position(line, character) {
    var _this2 = this;

    _classCallCheck(this, Position);

    this.lessThanOrEqualTo = function (position) {
      return _this2.line < position.line || _this2.line === position.line && _this2.character <= position.character;
    };

    this.line = line;
    this.character = character;
  }

  Position.prototype.setLine = function setLine(line) {
    this.line = line;
  };

  Position.prototype.setCharacter = function setCharacter(character) {
    this.character = character;
  };

  return Position;
}();

function offsetToPosition(text, loc) {
  var EOL = '\n';
  var buf = text.slice(0, loc);
  var lines = buf.split(EOL).length - 1;
  var lastLineIndex = buf.lastIndexOf(EOL);
  return new Position(lines, loc - lastLineIndex - 1);
}

function locToRange(text, loc) {
  var start = offsetToPosition(text, loc.start);
  var end = offsetToPosition(text, loc.end);
  return new Range(start, end);
}