"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.requiresFieldsMissingOnBase = ({ schema, }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        for (const [fieldName, field] of Object.entries(namedType.getFields())) {
            const serviceName = field.federation && field.federation.serviceName;
            if (!serviceName)
                continue;
            if (field.federation && field.federation.requires) {
                const selections = field.federation.requires;
                for (const selection of selections) {
                    const matchingFieldOnType = namedType.getFields()[selection.name.value];
                    if (matchingFieldOnType &&
                        matchingFieldOnType.federation &&
                        matchingFieldOnType.federation.serviceName) {
                        errors.push(utils_1.errorWithCode('REQUIRES_FIELDS_MISSING_ON_BASE', utils_1.logServiceAndType(serviceName, typeName, fieldName) +
                            `requires the field \`${selection.name.value}\` to be @external. @external fields must exist on the base type, not an extension.`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=requiresFieldsMissingOnBase.js.map