"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.providesFieldsMissingExternal = ({ schema, }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        for (const [fieldName, field] of Object.entries(namedType.getFields())) {
            const serviceName = field.federation && field.federation.serviceName;
            if (!serviceName)
                continue;
            const fieldType = field.type;
            if (!graphql_1.isObjectType(fieldType))
                continue;
            const externalFieldsOnTypeForService = fieldType.federation &&
                fieldType.federation.externals &&
                fieldType.federation.externals[serviceName];
            if (field.federation && field.federation.provides) {
                const selections = field.federation.provides;
                for (const selection of selections) {
                    const foundMatchingExternal = externalFieldsOnTypeForService
                        ? externalFieldsOnTypeForService.some(ext => ext.field.name.value === selection.name.value)
                        : undefined;
                    if (!foundMatchingExternal) {
                        errors.push(utils_1.errorWithCode('PROVIDES_FIELDS_MISSING_EXTERNAL', utils_1.logServiceAndType(serviceName, typeName, fieldName) +
                            `provides the field \`${selection.name.value}\` and requires ${fieldType}.${selection.name.value} to be marked as @external.`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=providesFieldsMissingExternal.js.map