"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("apollo-server-env");
const graphql_1 = require("graphql");
const utils_1 = require("../../utils");
exports.externalMissingOnBase = ({ schema }) => {
    const errors = [];
    const types = schema.getTypeMap();
    for (const [typeName, namedType] of Object.entries(types)) {
        if (!graphql_1.isObjectType(namedType))
            continue;
        if (namedType.federation && namedType.federation.externals) {
            for (const [serviceName, externalFieldsForService] of Object.entries(namedType.federation.externals)) {
                for (const { field: externalField } of externalFieldsForService) {
                    const externalFieldName = externalField.name.value;
                    const allFields = namedType.getFields();
                    const matchingBaseField = allFields[externalFieldName];
                    if (!matchingBaseField) {
                        errors.push(utils_1.errorWithCode('EXTERNAL_MISSING_ON_BASE', utils_1.logServiceAndType(serviceName, typeName, externalFieldName) +
                            `marked @external but ${externalFieldName} is not defined on the base service of ${typeName} (${namedType.federation.serviceName})`));
                        continue;
                    }
                    if (matchingBaseField.federation &&
                        matchingBaseField.federation.serviceName) {
                        errors.push(utils_1.errorWithCode('EXTERNAL_MISSING_ON_BASE', utils_1.logServiceAndType(serviceName, typeName, externalFieldName) +
                            `marked @external but ${externalFieldName} was defined in ${matchingBaseField.federation.serviceName}, not in the service that owns ${typeName} (${namedType.federation.serviceName})`));
                    }
                }
            }
        }
    }
    return errors;
};
//# sourceMappingURL=externalMissingOnBase.js.map