// Following is adapted from Vue CLI v2 "init" command

const chalk = require('chalk')

/**
 * Evaluate an expression in meta.json in the context of
 * prompt answers data.
 */

module.exports = function evaluate (exp, data) {
  /* eslint-disable no-new-func */
  const fn = new Function('data', 'with (data) { return ' + exp + '}')

  try {
    return fn(data)
  }
  catch (e) {
    console.error(chalk.red('Error when evaluating filter condition: ' + exp))
  }
}
